import os
from dataclasses import dataclass

@dataclass(frozen=True)
class Config:
    bot_token: str
    base_url: str
    webhook_secret: str
    data_dir: str

def load_config() -> Config:
    bot_token = os.environ.get("BOT_TOKEN", "").strip()
    base_url = os.environ.get("BASE_URL", "").strip().rstrip("/")
    webhook_secret = os.environ.get("WEBHOOK_SECRET", "").strip()
    data_dir = os.environ.get("DATA_DIR", "data").strip()

    if not bot_token:
        raise RuntimeError("BOT_TOKEN is required")
    if not base_url:
        raise RuntimeError("BASE_URL is required (e.g. https://example.com)")
    if not webhook_secret:
        raise RuntimeError("WEBHOOK_SECRET is required")
    return Config(
        bot_token=bot_token,
        base_url=base_url,
        webhook_secret=webhook_secret,
        data_dir=data_dir,
    )
    